﻿Option Strict On
Option Explicit On
Option Infer Off

Imports System.IO
Imports System.Threading

Public Class Form1

    Dim TekstZmieniony As Boolean = False
    Dim sr As StringReader = Nothing

    Private Sub ZamknijToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles ZamknijToolStripMenuItem.Click
        'Close()
        Application.Exit()
    End Sub

    Private Sub Form1_FormClosing(sender As System.Object, e As System.Windows.Forms.FormClosingEventArgs) Handles MyBase.FormClosing
        If Not TekstZmieniony Then Return
        Dim dr As DialogResult = MessageBox.Show("Czy zapisać zmiany w edytowanym dokumencie?", Me.Text, MessageBoxButtons.YesNoCancel, MessageBoxIcon.Question, MessageBoxDefaultButton.Button3)
        Select Case dr
            Case DialogResult.Yes
                'MessageBox.Show("Wstawić wywołanie metody zapisującej zawartość notatnika do pliku")
                ZapiszJakoToolStripMenuItem_Click(Nothing, Nothing)
            Case DialogResult.No
            Case DialogResult.Cancel
                e.Cancel = True
            Case Else
                e.Cancel = True
        End Select
    End Sub

    Private Sub TextBox1_TextChanged(sender As System.Object, e As System.EventArgs) Handles TextBox1.TextChanged
        TekstZmieniony = True
    End Sub

    Private Sub PasekstanuToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles PasekstanuToolStripMenuItem.Click
        PasekstanuToolStripMenuItem.Checked = Not PasekstanuToolStripMenuItem.Checked
        StatusStrip1.Visible = PasekstanuToolStripMenuItem.Checked
    End Sub

    Public Shared Function CzytajPlikTekstowy(nazwaPliku As String) As String()
        Dim tekst As List(Of String) = New List(Of String)
        Try
            Using sr As StreamReader = New StreamReader(nazwaPliku)
                Dim wiersz As String = sr.ReadLine()
                While Not wiersz Is Nothing
                    tekst.Add(wiersz)
                    wiersz = sr.ReadLine()
                End While
                sr.Close()
                Return tekst.ToArray()
            End Using
        Catch e As Exception
            MessageBox.Show("Błąd odczytu pliku " & nazwaPliku & " (" & e.Message & ")")
            Return Nothing
        End Try
    End Function

    Private Sub OtwórzToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles OtwórzToolStripMenuItem.Click
        If OpenFileDialog1.ShowDialog() = DialogResult.OK Then
            Dim nazwaPliku As String = OpenFileDialog1.FileName
            TextBox1.Lines = CzytajPlikTekstowy(nazwaPliku)
            Dim ostatniSlash As Integer = nazwaPliku.LastIndexOf("\")
            ToolStripStatusLabel1.Text = nazwaPliku.Substring(ostatniSlash + 1, nazwaPliku.Length - ostatniSlash - 1)
            TekstZmieniony = False
        End If
    End Sub

    Public Shared Sub ZapiszDoPlikuTekstowego(nazwaPliku As String, tekst As String())
        Using sw As StreamWriter = New StreamWriter(nazwaPliku)
            For Each wiersz As String In tekst
                sw.WriteLine(wiersz)
            Next
            sw.Close()
        End Using
    End Sub

    Private Sub ZapiszJakoToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles ZapiszJakoToolStripMenuItem.Click
        Dim nazwaPliku As String = OpenFileDialog1.FileName
        If nazwaPliku.Length > 0 Then SaveFileDialog1.FileName = nazwaPliku
        If SaveFileDialog1.ShowDialog() = DialogResult.OK Then
            nazwaPliku = SaveFileDialog1.FileName
            ZapiszDoPlikuTekstowego(nazwaPliku, TextBox1.Lines)
            Dim ostatniSlash As Integer = nazwaPliku.LastIndexOf("\")
            ToolStripStatusLabel1.Text = nazwaPliku.Substring(ostatniSlash + 1, nazwaPliku.Length - ostatniSlash - 1)
            TekstZmieniony = False
        End If
    End Sub

    Private Sub CzcionkaToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles CzcionkaToolStripMenuItem.Click
        FontDialog1.Font = TextBox1.Font
        If FontDialog1.ShowDialog() = DialogResult.OK Then
            TextBox1.Font = FontDialog1.Font
        End If
    End Sub

    Private Sub TłoToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles TłoToolStripMenuItem.Click
        ColorDialog1.Color = TextBox1.BackColor
        If ColorDialog1.ShowDialog() = DialogResult.OK Then
            TextBox1.BackColor = ColorDialog1.Color
        End If
    End Sub

    Private Sub CofnijToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles CofnijToolStripMenuItem.Click
        TextBox1.Undo()
    End Sub

    Private Sub WytnijToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles WytnijToolStripMenuItem.Click
        TextBox1.Cut()
    End Sub

    Private Sub KopiujToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles KopiujToolStripMenuItem.Click
        TextBox1.Copy()
    End Sub

    Private Sub WklejToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles WklejToolStripMenuItem.Click
        TextBox1.Paste()
    End Sub

    Private Sub UsuńToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles UsuńToolStripMenuItem.Click
        TextBox1.SelectedText = ""
    End Sub

    Private Sub ZaznaczWszystkoToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles ZaznaczWszystkoToolStripMenuItem.Click
        TextBox1.SelectAll()
    End Sub

    Private Sub PrintDocument1_PrintPage(sender As System.Object, e As System.Drawing.Printing.PrintPageEventArgs) Handles PrintDocument1.PrintPage
        Dim czcionka As Font = TextBox1.Font
        Dim wysokoscWiersza As Integer = CInt(czcionka.GetHeight(e.Graphics))
        Dim iloscLinii As Integer = e.MarginBounds.Height \ wysokoscWiersza

        'If IsNothing(sr) Then sr = New StringReader(TextBox1.Text) 'czy pierwsza strona?
        'teraz przy dzieleniu linii nie dbamy o spacje
        If IsNothing(sr) Then
            Dim tekst As String = ""
            For Each wiersz As String In TextBox1.Lines
                Dim szerokosc As Single = e.Graphics.MeasureString(wiersz, czcionka).Width
                If szerokosc < e.MarginBounds.Width Then
                    tekst &= wiersz & vbNewLine
                Else
                    Dim sredniaSzerokoscLitery As Single = szerokosc / wiersz.Length
                    Dim ileLiterWWierszu As Integer = CInt(e.MarginBounds.Width / sredniaSzerokoscLitery)

                    'Dim ileRazy As Integer = wiersz.Length \ ileLiterWWierszu 'ile pełnych wierszy
                    'For i = 1 To ileRazy
                    '    tekst &= wiersz.Substring((i - 1) * ileLiterWWierszu, ileLiterWWierszu) & vbNewLine
                    'Next
                    ''kopiowanie reszty wiersza
                    'tekst &= wiersz.Substring(ileRazy * ileLiterWWierszu) & vbNewLine

                    Dim skracanyWiersz As String = wiersz
                    Do
                        Dim ostatniaSpacja As Integer = skracanyWiersz.Substring(0, Math.Min(ileLiterWWierszu, skracanyWiersz.Length)).LastIndexOf(" ")
                        Dim iloscLiter As Integer = If(ostatniaSpacja <> -1, Math.Min(ostatniaSpacja, ileLiterWWierszu), ileLiterWWierszu)
                        tekst &= skracanyWiersz.Substring(0, iloscLiter) & vbNewLine
                        skracanyWiersz = skracanyWiersz.Substring(iloscLiter).TrimStart(" "c) 'pozostala czesc
                    Loop While skracanyWiersz.Length > ileLiterWWierszu
                    tekst &= skracanyWiersz & vbNewLine 'ostatnia część

                End If
            Next 'For Each
            sr = New StringReader(tekst)
        End If 'IsNothing(sr)

        e.HasMorePages = True

        For i As Integer = 1 To iloscLinii
            Dim wiersz As String = sr.ReadLine()
            If IsNothing(wiersz) Then
                e.HasMorePages = False
                sr = Nothing
                Exit For
            End If
            e.Graphics.DrawString(
                wiersz,
                czcionka,
                Brushes.Black,
                e.MarginBounds.Left,
                e.MarginBounds.Top + i * wysokoscWiersza)
        Next
    End Sub

    Private Sub drukujToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles drukujToolStripMenuItem.Click
        If PrintDialog1.ShowDialog() = DialogResult.OK Then
            PrintDocument1.DocumentName = "Notatnik.NET - " + ToolStripStatusLabel1.Text
            'PrintDocument1.Print()
            'BackgroundWorker1.RunWorkerAsync()
            Dim watek As Thread = New Thread(New ThreadStart(AddressOf PrintDocument1.Print))
            watek.IsBackground = True
            watek.Start()
        End If
    End Sub

    Private Sub ustawieniaStronyToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles ustawieniaStronyToolStripMenuItem.Click
        PageSetupDialog1.ShowDialog()
    End Sub

    Private Sub podglądWydrukuToolStripMenuItem_Click(sender As System.Object, e As System.EventArgs) Handles podglądWydrukuToolStripMenuItem.Click
        PrintPreviewDialog1.ShowDialog()
    End Sub

    Private Sub BackgroundWorker1_DoWork(sender As System.Object, e As System.ComponentModel.DoWorkEventArgs) Handles BackgroundWorker1.DoWork
        PrintDocument1.Print()
    End Sub

    Private Sub TextBox1_DragOver(sender As System.Object, e As System.Windows.Forms.DragEventArgs) Handles TextBox1.DragOver
        If e.Data.GetDataPresent(DataFormats.FileDrop) Then
            e.Effect = DragDropEffects.Move
        End If
    End Sub

    'Private Sub TextBox1_DragDrop(sender As System.Object, e As System.Windows.Forms.DragEventArgs) Handles TextBox1.DragDrop
    '    If e.Data.GetDataPresent(DataFormats.FileDrop) Then
    '        Dim nazwyPrzenoszonychPlikow As String() = e.Data.GetData(DataFormats.FileDrop)
    '        Dim komunikat As String = "Nazwy przenoszonych plików:" & vbNewLine
    '        For Each nazwaPliku As String In nazwyPrzenoszonychPlikow
    '            komunikat += nazwaPliku & vbNewLine
    '        Next
    '        MessageBox.Show(komunikat)
    '    End If
    'End Sub

    Private Sub TextBox1_DragDrop(sender As System.Object, e As System.Windows.Forms.DragEventArgs) Handles TextBox1.DragDrop
        If e.Data.GetDataPresent(DataFormats.FileDrop) Then
            Dim nazwyPrzenoszonychPlikow As String() = CType(e.Data.GetData(DataFormats.FileDrop), String())

            'wczytujemy pierwszy plik
            Dim nazwaPliku As String = nazwyPrzenoszonychPlikow(0)
            TextBox1.Lines = CzytajPlikTekstowy(nazwaPliku)
            Dim ostatniSlash As Integer = nazwaPliku.LastIndexOf("\")
            ToolStripStatusLabel1.Text = nazwaPliku.Substring(ostatniSlash + 1, nazwaPliku.Length - ostatniSlash - 1)
        End If
    End Sub
End Class
